<?php defined('ALTUMCODE') || die() ?>

<div class="container">
    <?= \Altum\Alerts::output_alerts() ?>

    <?php if(settings()->main->breadcrumbs_is_enabled): ?>
        <nav aria-label="breadcrumb">
            <ol class="custom-breadcrumbs small">
                <li><a href="<?= url('tools') ?>"><?= l('tools.breadcrumb') ?></a> <i class="fas fa-fw fa-angle-right"></i></li>
                <li class="active" aria-current="page"><?= l('tools.ping.name') ?></li>
            </ol>
        </nav>
    <?php endif ?>

    <div class="row mb-4">
        <div class="col-12 col-lg d-flex align-items-center mb-3 mb-lg-0 text-truncate">
            <h1 class="h4 m-0 text-truncate"><?= l('tools.ping.name') ?></h1>

            <div class="ml-2">
                <span data-toggle="tooltip" title="<?= l('tools.ping.description') ?>">
                    <i class="fas fa-fw fa-info-circle text-muted"></i>
                </span>
            </div>
        </div>

        <?= $this->views['ratings'] ?>
    </div>

    <div class="card">
        <div class="card-body">

            <form action="" method="post" role="form">
                <input type="hidden" name="token" value="<?= \Altum\Csrf::get() ?>" />

                <div class="form-group" data-type="website">
                    <label for="target_website_url"><i class="fas fa-fw fa-sm fa-link text-muted mr-1"></i> <?= l('tools.ping.target_url') ?></label>
                    <input type="url" id="target_website_url" name="target" class="form-control <?= \Altum\Alerts::has_field_errors('target') ? 'is-invalid' : null ?>" value="<?= $data->values['target'] ?>" placeholder="<?= l('global.url_placeholder') ?>" required="required" />
                    <?= \Altum\Alerts::output_field_error('target') ?>
                </div>

                <button type="submit" name="submit" class="btn btn-block btn-primary"><?= l('global.submit') ?></button>
            </form>

        </div>
    </div>

    <?php if(isset($data->result)): ?>
        <div class="mt-4">
            <div class="table-responsive table-custom-container">
                <table class="table table-custom">
                    <tbody>

                    <tr>
                        <td class="font-weight-bold">
                            <?= l('global.url') ?>
                        </td>
                        <td class="text-nowrap">
                            <img referrerpolicy="no-referrer" src="<?= get_favicon_url_from_domain(parse_url($data->values['target'], PHP_URL_HOST)) ?>" class="img-fluid icon-favicon mr-1" /> <?= remove_url_protocol_from_url($data->values['target']) ?>
                        </td>
                    </tr>

                    <?php if(isset($data->result['ping_server_id'])): ?>
                        <tr>
                            <td class="font-weight-bold">
                                <?= l('tools.ping.result.ping_server_id') ?>
                            </td>
                            <td class="text-nowrap">
                                <img src="<?= ASSETS_FULL_URL . 'images/countries/' . mb_strtolower($data->ping_servers[$data->result['ping_server_id']]->country_code) . '.svg' ?>" class="img-fluid icon-favicon mr-1" /> <?= get_country_from_country_code($data->ping_servers[$data->result['ping_server_id']]->country_code). ', ' . $data->ping_servers[$data->result['ping_server_id']]->city_name ?>
                            </td>
                        </tr>
                    <?php endif ?>

                    <?php if(isset($data->result['is_ok'])): ?>
                        <tr>
                            <td class="font-weight-bold">
                                <?= l('global.status') ?>
                            </td>
                            <td class="text-nowrap">
                                <?php if($data->result['is_ok']): ?>
                                    <i class="fas fa-fw fa-sm fa-check-circle text-success"></i> <?= l('tools.ping.result.is_ok') ?>
                                <?php else: ?>
                                    <i class="fas fa-fw fa-sm fa-times-circle text-danger"></i> <?= l('tools.ping.result.is_not_ok') ?>
                                <?php endif ?>
                            </td>
                        </tr>
                    <?php endif ?>

                    <?php if(isset($data->result['response_time'])): ?>
                        <tr>
                            <td class="font-weight-bold">
                                <?= l('tools.ping.result.response_time') ?>
                            </td>
                            <td class="text-nowrap">
                                <?= display_response_time($data->result['response_time']) ?>
                            </td>
                        </tr>
                    <?php endif ?>

                    <?php if(isset($data->result['response_status_code'])): ?>
                        <tr>
                            <td class="font-weight-bold">
                                <?= l('tools.ping.result.response_status_code') ?>
                            </td>
                            <td class="text-nowrap">
                                <?= $data->result['response_status_code'] ?>
                            </td>
                        </tr>
                    <?php endif ?>

                    <?php if(isset($data->result['error'])): ?>
                        <tr>
                            <td class="font-weight-bold">
                                <?= l('tools.ping.result.error') ?>
                            </td>
                            <td class="text-nowrap">
                                <?= $data->result['error']['message'] ?? l('global.none') ?>
                            </td>
                        </tr>
                    <?php endif ?>

                    </tbody>
                </table>
            </div>
        </div>
    <?php endif ?>

    <?php if(settings()->tools->last_submissions_is_enabled && isset($data->tools_usage[\Altum\Router::$method]) && !empty((array) $data->tools_usage[\Altum\Router::$method]->data)): ?>
        <div class="mt-5">
            <h2 class="small font-weight-bold text-uppercase text-muted mb-3"><i class="fas fa-fw fa-sm fa-plus text-primary mr-1"></i> <?= l('tools.last_submissions') ?></h2>

            <div class="card">
                <div class="card-body">

                    <div class="row">
                        <?php foreach((array) $data->tools_usage[\Altum\Router::$method]->data as $key => $value): ?>
                            <div class="col-12 col-lg-6">
                                <div class="text-truncate my-2">
                                    <a href="<?= url('tools/' . str_replace('_', '-', \Altum\Router::$method) . '?' . http_build_query((array) $value)) ?>" onclick="this.href += '&submit=1<?= \Altum\Csrf::get_url_query() ?>'">
                                        <img referrerpolicy="no-referrer" src="<?= get_favicon_url_from_domain(parse_url($value->target, PHP_URL_HOST)) ?>" class="img-fluid icon-favicon mr-1" loading="lazy" />

                                        <?= remove_url_protocol_from_url($value->target) ?>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach ?>
                    </div>

                </div>
            </div>
        </div>

        <?php endif ?>

    <?php require_once THEME_PATH . 'views/tools/js_dynamic_url_processor.php' ?>

    <?= $this->views['extra_content'] ?>

    <?= $this->views['similar_tools'] ?>

    <?= $this->views['popular_tools'] ?>
</div>

<?php include_view(THEME_PATH . 'views/partials/clipboard_js.php') ?>

