<?php defined('ALTUMCODE') || die() ?>

<div class="dropdown">
    <button type="button" class="btn btn-link <?= $data->button_text_class ?? 'text-secondary' ?> dropdown-toggle dropdown-toggle-simple" data-toggle="dropdown" data-boundary="viewport">
        <i class="fas fa-fw fa-ellipsis-v"></i>
    </button>

    <div class="dropdown-menu dropdown-menu-right">
        <a href="<?= url('incident/' . $data->id) ?>" class="dropdown-item" ><i class="fas fa-fw fa-sm fa-eye mr-2"></i> <?= l('global.view') ?></a>
        <a href="#" data-toggle="modal" data-target="#incident_comment_modal" data-incident-id="<?= $data->id ?>" data-comment="<?= $data->comment ?>" data-is-solved="<?= (int) !empty($data->end_datetime) ?>" class="dropdown-item"><i class="fas fa-fw fa-sm fa-pencil-alt mr-2"></i> <?= l('global.edit') ?></a>
        <a href="#" data-toggle="modal" data-target="#incident_delete_modal" data-incident-id="<?= $data->id ?>" class="dropdown-item"><i class="fas fa-fw fa-sm fa-trash-alt mr-2"></i> <?= l('global.delete') ?></a>
    </div>
</div>

<?php \Altum\Event::add_content(include_view(THEME_PATH . 'views/partials/universal_delete_modal_form.php', [
    'name' => 'incident',
    'resource_id' => 'incident_id',
    'has_dynamic_resource_name' => false,
    'path' => 'incidents/delete'
]), 'modals', 'incident_delete_modal'); ?>

