<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

defined('ALTUMCODE') || die();

/* Easily configurable footer socials */

return [
    'threads' => [
        'name' => 'Threads',
        'icon' => 'fab fa-threads',
        'format' => 'https://threads.com/@%s',
        'input_display_format' => true,
        'placeholder' => '',
        'color' => '#808080',
        'background_color' => 'rgba(128, 128, 128, 0.1)',
    ],

    'youtube' => [
        'name' => 'YouTube',
        'icon' => 'fab fa-youtube',
        'format' => 'https://youtube.com/%s',
        'input_display_format' => true,
        'placeholder' => '',
        'color' => '#FF0000',
        'background_color' => 'rgba(255, 0, 0, 0.1)',
    ],

    'facebook' => [
        'name' => 'Facebook',
        'icon' => 'fab fa-facebook',
        'format' => 'https://facebook.com/%s',
        'input_display_format' => true,
        'placeholder' => '',
        'color' => '#1877F2',
        'background_color' => 'rgba(24, 119, 242, 0.1)',
    ],

    'x' => [
        'name' => 'X',
        'icon' => 'fab fa-x-twitter',
        'format' => 'https://x.com/%s',
        'input_display_format' => true,
        'placeholder' => '',
        'color' => '#1DA1F2',
        'background_color' => 'rgba(29, 161, 242, 0.1)',
    ],

    'instagram' => [
        'name' => 'Instagram',
        'icon' => 'fab fa-instagram',
        'format' => 'https://instagram.com/%s',
        'input_display_format' => true,
        'placeholder' => '',
        'color' => '#C13584',
        'background_color' => 'rgba(193, 53, 132, 0.1)',
    ],

    'tiktok' => [
        'name' => 'TikTok',
        'icon' => 'fab fa-tiktok',
        'format' => 'https://tiktok.com/@%s',
        'input_display_format' => true,
        'placeholder' => '',
        'color' => '#69C9D0',
        'background_color' => 'rgba(105, 201, 208, 0.1)',
    ],

    'linkedin' => [
        'name' => 'LinkedIn',
        'icon' => 'fab fa-linkedin',
        'format' => 'https://linkedin.com/%s',
        'input_display_format' => true,
        'placeholder' => '',
        'color' => '#0077B5',
        'background_color' => 'rgba(0, 119, 181, 0.1)',
    ],

    'whatsapp' => [
        'name' => 'WhatsApp',
        'icon' => 'fab fa-whatsapp',
        'format' => 'https://wa.me/%s',
        'input_display_format' => false,
        'placeholder' => '010101010101',
        'color' => '#25D366',
        'background_color' => 'rgba(37, 211, 102, 0.1)',
    ],

    'email'=> [
        'name' => 'Email',
        'icon' => 'fas fa-envelope',
        'format' => 'mailto:%s',
        'input_display_format' => false,
        'placeholder' => 'hey@example.com',
        'color' => '#3b5998',
        'background_color' => 'rgba(59, 89, 152, 0.1)',
    ],
];
